if LANGUAGE eq US_ENGLISH
	public	usage_msg, copyright_msg
usage_msg	label	byte
	db "usage: ",driver_name
 	db	" [options] <packet_int_no> <hardware_irq> <io_addr>",CR,LF,'$'
copyright_msg	label byte
	db "Packet driver for the ",long_name,", version "
	db '0'+(majver / 10),'0'+(majver mod 10),"."
	db '0'+(version / 10),'0'+(version mod 10),CR,LF
;	db "Supports: Plug and Play, ISA, NETID.",CR,LF
	db "Supports: ISA, NETID.",CR,LF
	db "Portions written by Morien W. Roberts; "
	db "NETID code by M. Robb Main of Megatel.",CR,LF,'$'

memory_bad_msg	db	"Ethernet buffer memory bad.",CR,LF,'$'
testing_mem_msg	db	"Testing memory .",'$'

byte_msg	db "Performing 8 bit I/O transfers.",CR,LF,'$'
word_msg	db "Performing 16 bit I/O transfers.",CR,LF,'$'

pnp_bios_msg	db  "Plug and Play BIOS found.",CR,LF,'$'
no_pnp_bios_msg db  "No Plug and Play BIOS was found.",CR,LF,'$'
pnp_card_msg	db  "Plug and Play ",long_name," was found.",CR,LF,'$'
no_pnp_card_msg	db  "No Plug and Play ",long_name," was found.",CR,LF,'$'


irq_too_big_msg	label	byte
	db "The ",long_name," is in an 8-bit slot but is configured to",CR,LF
	db "use an interrupt that is not available in an 8-bit slot.",CR,LF
	db "The driver will not load",CR,LF
	db "Please use ",config_software
	db " to select an interrupt less than 8 or, for better",CR,LF
	db "performance, move the adapter to a 16-bit slot.",CR,LF,'$'

eight_in_sixteen_msg	label	byte
	db "The ",long_name," is configured for 8-bit operation but is in a",CR,LF
	db "16-bit slot.  For better performance, use ",config_software
	db " to configure for a 16-bit",CR,LF
	db "bus slot.",CR,LF,'$'

sixteen_better_msg	label	byte
	db "The ",long_name," is installed in an 8-bit slot.  For better",CR,LF
	db "performance move the adapter to a 16-bit slot.",CR,LF,'$'

int_bad_msg			db	"That interrupt number is not supported.",CR,LF
					db	"This ",long_name," can only use IRQs "
dummy_msg			db	'$'
int_no_name			db	"Interrupt number ",'$'
io_addr_name		db	"I/O port ",'$'
separator1_msg		db	", $"
separator3_msg		db	" & $"
specified_failed 	db	"An ",long_name
					db	" was not found at specified address.",CR,LF,'$'
scan_failed 		db	"Scan of I/O space did not find ",long_name,CR,LF,'$'
more_than_one_msg	db "Found more than one ",long_name
					db " cards at the I/O addresses:",CR,LF,'$'
specify_which_msg	db "You must specify the I/O address of the card you wish"
					db " to use.",CR,LF,'$'
eeprom_chksum_bad	db	"EEPROM Failed checksum validation; "
					db	"looking for NETIDBLK.",CR,LF,'$'
nidblk_found		db	"NetId Block found @SEG:",'$'
nidblk_scan_fail	db	"Unable to locate NetId Block.",CR,LF,'$'
nidblk_wrong_io		db	"NetId Block Port # does not match: ",'$'
nidblk_chksum_bad	db	"NetId Block failed checksum validation.",CR,LF,'$'
found_two			db	"Found two ", long_name," cards.",CR,LF,'$'
assumed_msg			db	"No EEPROM, No NetId Block, "
					db	"using command line parameters.",CR,LF,'$'
found_pcmcia_msg	db	"Using PCMCIA bus.",CR,LF,'$'

using_auto_msg	db	"Auto detecting media",CR,LF,'$'
using_10B_T_msg	db	"Using twisted pair cable",CR,LF,'$'
using_AUI_msg	db	"Using AUI interface",CR,LF,'$'
using_10B_2_msg	db	"Using coax cable",CR,LF,'$'
using_bnc_aui_msg	db "Using either AUI interface or coax cable",CR,LF,'$'

negotiation_msg	db 	"Performing auto-negotiation for full / half duplex"
				db	" communication.",CR,LF,'$'
full_duplex_msg	db	"Using full duplex communication.",CR,LF,'$'
half_duplex_msg	db	"Using half duplex communication.",CR,LF,'$'
neg_problem_msg db 	"**** Full / half duplex auto-negotiation timmed out ****"
				db	CR,LF,'$'
endif
